// priority: 30

function 获取传送授权数据(p) {
    if (!p || !p.persistentData) return { "传送次数": 0, "传送截止时间戳": 0 };
    let pDATA = p.persistentData;
    return { "传送次数": pDATA.传送授权_次数 ?? 0, "传送截止时间戳": pDATA.传送授权_截止时间戳 ?? 0 };
}

function 玩家拥有传送授权(p) {
    if (!p) return false;
    let 玩家授权数据 = 获取传送授权数据(p);
    return 玩家授权数据["传送次数"] > 0 || 玩家授权数据["传送截止时间戳"] > Date.now();
}

function 消耗传送授权机会(p) {
    if (!p || !p.persistentData) return;
    let pDATA = p.persistentData;
    let 原始次数 = pDATA.传送授权_次数 ?? 0;
    let 原始时间戳 = pDATA.传送授权_截止时间戳 ?? 0;
    let 授权已消耗 = false;

    if (原始时间戳 <= Date.now() && 原始次数 > 0) {
        pDATA.传送授权_次数 = Math.max(0, 原始次数 - 1);
        授权已消耗 = true;
    }

    let 最终次数 = pDATA.传送授权_次数 ?? 0;
    let 最终时间戳 = pDATA.传送授权_截止时间戳 ?? 0;

    if (最终次数 <= 0 && (最终时间戳 === 0 || Date.now() >= 最终时间戳)) {
        if (授权已消耗 || (原始时间戳 > 0 && Date.now() >= 原始时间戳)) {
            pDATA.传送授权_次数 = 0;
            pDATA.传送授权_截止时间戳 = 0;
        }
    }
}

function 发送传送授权状态消息(p) {
    if (!p || typeof p.isPlayer !== "function" || !p.isPlayer() || p.removed) return;
    let { "传送次数": 次数, "传送截止时间戳": 截止时间戳 } = 获取传送授权数据(p);
    let 当前时间戳 = Date.now();
    let 拥有时间权限 = 截止时间戳 > 当前时间戳;
    if (次数 > 0) {
        p.tell(Text.of("[传送授权] 您还有 ").aqua().append(Text.of(`${次数}`).white().bold()).append(Text.of(" 次传送授权。").aqua()));
    } else if (拥有时间权限) {
        let 剩余秒数 = Math.floor((截止时间戳 - 当前时间戳) / 1000);
        p.tell(Text.of("[传送授权] 您可在接下来 ").aqua().append(Text.of(`${剩余秒数}`).white().bold()).append(Text.of(" 秒内无限传送。").aqua()));
    } else {
        p.tell(Text.of("[传送授权] 您的传送授权已消耗完毕。").yellow());
    }
}

function 处理玩家传送命令逻辑(e, 命令名, 传入的命令源) { 
    let 执行p = null;
    let 实际命令源 = 传入的命令源 || e.source; 

    if (实际命令源 && 实际命令源.player) { 
        执行p = 实际命令源.player;
    } else if (e.player) { 
        执行p = e.player;
    } else if (实际命令源 && typeof 实际命令源.getEntity === "function") {
        let 实体 = 实际命令源.getEntity();
        if (实体 && typeof 实体.isPlayer === "function" && 实体.isPlayer()) {
            执行p = 实体;
        }
    }

    if (!执行p) {
        if (实际命令源 && typeof 实际命令源.sendFailure === "function") {
             实际命令源.sendFailure(Text.of("非玩家命令源无权执行此传送命令。"));
        } else if (e.source && typeof e.source.sendFailure === "function") { 
            e.source.sendFailure(Text.of("非玩家命令源无权执行此传送命令。"));
        }
        if (typeof e.cancel === "function") e.cancel();
        return;
    }

    if (!玩家拥有传送授权(执行p)) {
        执行p.tell(Text.of(`您没有有效的传送授权来使用 /${命令名}。`).red());
        if (typeof e.cancel === "function") e.cancel();
        return;
    }

    let 输入命令 = e.input;
    let 格式允许 = false;

    if (输入命令 !== null && 输入命令 !== undefined) {
        let 小写输入命令 = String(输入命令).toLowerCase();
        let 参数字符串 = "";
        
        let 命令前缀带斜杠 = "/" + 命令名 + " ";
        let 命令前缀不带斜杠 = 命令名 + " ";

        if (小写输入命令.startsWith(命令前缀带斜杠)) {
            参数字符串 = 小写输入命令.substring(命令前缀带斜杠.length).trim();
        } else if (小写输入命令.startsWith(命令前缀不带斜杠)) {
            参数字符串 = 小写输入命令.substring(命令前缀不带斜杠.length).trim();
        } else if (小写输入命令 === "/" + 命令名 || 小写输入命令 === 命令名) {
            参数字符串 = ""; 
        }

        let 命令参数 = 参数字符串 === "" ? [] : 参数字符串.split(" ").map(部分 => String(部分).trim()).filter(部分 => 部分.length > 0);

        let 是有效坐标参数 = (待检查参数) => {
            if (待检查参数 === undefined || 待检查参数 === null) return false;
            let 参数文本 = String(待检查参数);
            let 坐标部分 = 参数文本.startsWith("~") ? 参数文本.substring(1) : 参数文本;
            if (坐标部分 === "" && 参数文本.startsWith("~")) return true;
            if (坐标部分 === "") return false;
            return /^-?(\d+(\.\d*)?|\.\d+)$/.test(坐标部分);
        };

        if (命令参数.length === 0) { 
            格式允许 = true; 
        } else if (命令参数.length >= 4 && 命令参数.length <= 6 && String(命令参数[0]) === "@s") {
            if (是有效坐标参数(命令参数[1]) && 是有效坐标参数(命令参数[2]) && 是有效坐标参数(命令参数[3])) {
                if ((命令参数.length < 5 || 是有效坐标参数(命令参数[4])) && (命令参数.length < 6 || 是有效坐标参数(命令参数[5]))) {
                    格式允许 = true;
                }
            }
        } else if (命令参数.length >= 3 && 命令参数.length <= 5) {
            if (是有效坐标参数(命令参数[0]) && 是有效坐标参数(命令参数[1]) && 是有效坐标参数(命令参数[2])) {
                if ((命令参数.length < 4 || 是有效坐标参数(命令参数[3])) && (命令参数.length < 5 || 是有效坐标参数(命令参数[4]))) {
                    格式允许 = true;
                }
            }
        }
    } else {
      格式允许 = true;
    }

    if (!格式允许) {
        执行p.tell(Text.of(`传送格式无效。所有玩家都只能使用 \`/${命令名} [<x> <y> <z>]\` 或 \`/${命令名} @s <x> <y> <z>\` 传送自己 (可附加旋转参数)，且需TPD授权。`).red());
        if (typeof e.cancel === "function") e.cancel();
        return;
    }

    消耗传送授权机会(执行p);
    let s = e.s || e.server;
    if (s && typeof s.scheduleInTicks === "function") {
        s.scheduleInTicks(1, () => {
            发送传送授权状态消息(执行p);
        });
    }
}

let 命令列表 = ["tp"];
命令列表.forEach(命令名称 => {
    ServerEvents.command(命令名称, e => {
        let 命令源实例 = null;
        let 是OP最终判断 = false;

        if (e && typeof e.getParseResults === "function") {
            let 解析结果 = e.getParseResults();
            if (解析结果 && typeof 解析结果.getContext === "function") {
                let 命令上下文 = 解析结果.getContext();
                if (命令上下文 && typeof 命令上下文.getSource === "function") {
                    命令源实例 = 命令上下文.getSource();
                }
            }
        }
        
        if (!命令源实例 && e.source) {
            命令源实例 = e.source;
        }

        if (命令源实例) {
            if (typeof 命令源实例.hasPermission === "function") {
                是OP最终判断 = 命令源实例.hasPermission(2);
            }
        } else if (e.player) { 
            if (typeof e.player.hasPermission === "function") {
                是OP最终判断 = e.player.hasPermission(2);
                if (是OP最终判断) {
                    命令源实例 = e.player; 
                }
            }
        }
        
        if (是OP最终判断) {
            return;
        }
        
        处理玩家传送命令逻辑(e, 命令名称, 命令源实例); 
    });
});

ServerEvents.commandRegistry(e => {
    let 命令 = e.commands;
    let 命令参数 = e.arguments;

    let 整数参数 = 命令参数.INTEGER.create(e);
    let P参数 = 命令参数.PLAYER.create(e);

    function 获取玩家传送数据(p) {
        let pDATA = p.persistentData;
        return {
            传送次数: pDATA.传送授权_次数 ?? 0,
            传送截止时间戳: pDATA.传送授权_截止时间戳 ?? 0,
        };
    }

    function 设置玩家传送次数(p, 次数) {
        p.persistentData.传送授权_次数 = Math.max(0, 次数);
        p.persistentData.传送授权_截止时间戳 = 0; 
    }

    function 设置玩家传送时限(p, 秒数) {
        let 当前时间戳 = Date.now();
        let 截止时间戳 = 当前时间戳 + Math.max(0, 秒数) * 1000;
        p.persistentData.传送授权_截止时间戳 = 截止时间戳;
        p.persistentData.传送授权_次数 = 0; 
    }

    function 清除玩家传送权限(p) {
        p.persistentData.remove("传送授权_次数");
        p.persistentData.remove("传送授权_截止时间戳");
    }

    function 玩家拥有传送权限(p) {
        let { 传送次数, 传送截止时间戳 } = 获取玩家传送数据(p);
        return 传送次数 > 0 || 传送截止时间戳 > Date.now();
    }

    function 消耗玩家传送机会(p) {
        let 当前数据 = 获取玩家传送数据(p);
        let 权限被消耗 = false;

        if (当前数据.传送截止时间戳 > Date.now()) {
            // 时间权限内,不消耗次数
        } else if (当前数据.传送次数 > 0) {
            设置玩家传送次数(p, 当前数据.传送次数 - 1);
            权限被消耗 = true;
        }

        let 最新数据 = 获取玩家传送数据(p);
        if (最新数据.传送次数 <= 0 && (最新数据.传送截止时间戳 === 0 || Date.now() >= 最新数据.传送截止时间戳)) {
            if (权限被消耗 || (当前数据.传送截止时间戳 > 0 && Date.now() >= 当前数据.传送截止时间戳)) {
                 清除玩家传送权限(p);
            }
        }
    }

    function 发送传送权限信息(p, 刚执行完传送操作) {
        if (!p || typeof p.isPlayer !== "function" || !p.isPlayer() || p.removed) {
            console.error(`尝试向无效的玩家对象发送传送权限信息。对象: ${p}`);
            return;
        }
        刚执行完传送操作 = !!刚执行完传送操作;

        let { 传送次数, 传送截止时间戳 } = 获取玩家传送数据(p);
        let 当前时间戳 = Date.now();
        let 拥有时间权限 = 传送截止时间戳 > 当前时间戳;

        if (传送次数 > 0) {
            p.tell(Text.of(`✔ 您还有 `).green().append(Text.of(`${传送次数}`).white().bold()).append(Text.of(` 次传送授权。`).green()));
        } else if (拥有时间权限) {
            let 剩余秒数 = Math.floor((传送截止时间戳 - 当前时间戳) / 1000);
            p.tell(Text.of(`✔ 您拥有 `).green().append(Text.of(`${剩余秒数}`).white().bold()).append(Text.of(` 秒内无限传送授权。`).green()));
        } else {
            if (刚执行完传送操作) {
                p.tell(Text.of("✔ 您的传送授权已消耗完毕。").yellow());
            } else {
                p.tell(Text.of("✖ 您当前没有传送授权。请通过任务或其他方式获取。").red());
            }
        }
    }

    e.register(
        命令.literal("tpd")
            .then(命令.literal("允许").requires(源 => 源.hasPermission(2))
                .executes(上下文 => {
                    let 执行者 = 上下文.source.player;
                    if (!执行者) { 上下文.source.sendFailure(Text.of("此指令需要由玩家执行。")); return 0; }
                    设置玩家传送次数(执行者, 1);
                    执行者.tell(Text.of("✔ 您已获得 ").green().append(Text.of("1 次").white().bold()).append(Text.of(" 传送授权。").green()));
                    return 1;
                })
                .then(命令.literal("次数").requires(源 => 源.hasPermission(2))
                    .then(命令.argument("数量", 整数参数)
                        .executes(上下文 => {
                            let 执行者 = 上下文.source.player;
                            if (!执行者) { 上下文.source.sendFailure(Text.of("此指令需要由玩家执行。")); return 0; }
                            let 数量值 = 命令参数.INTEGER.getResult(上下文, "数量");
                            设置玩家传送次数(执行者, 数量值);
                            执行者.tell(Text.of(`✔ 您已获得 `).green().append(Text.of(`${获取玩家传送数据(执行者).传送次数}`).white().bold()).append(Text.of(` 次传送授权。`).green()));
                            return 1;
                        })
                        .then(命令.argument("目标", P参数)
                            .executes(上下文 => {
                                let 目标p = 命令参数.PLAYER.getResult(上下文, "目标");
                                let 数量值 = 命令参数.INTEGER.getResult(上下文, "数量");
                                设置玩家传送次数(目标p, 数量值);
                                上下文.source.sendSuccess(Text.of(`✔ 已为玩家 `).green().append(Text.of(目标p.name.string).yellow()).append(Text.of(` 设置 `).green()).append(Text.of(`${获取玩家传送数据(目标p).传送次数} 次`).white().bold()).append(Text.of(` 传送授权。`).green()), true);
                                if (上下文.source.player === null || !目标p.uuid.equals(上下文.source.player.uuid) ) {
                                    目标p.tell(Text.of(`✔ 管理员已为您设置 `).aqua().append(Text.of(`${获取玩家传送数据(目标p).传送次数} 次`).white().bold()).append(Text.of(` 传送授权。`).aqua()));
                                }
                                return 1;
                            })
                        )
                    )
                )
                .then(命令.literal("时间").requires(源 => 源.hasPermission(2))
                    .then(命令.argument("秒数", 整数参数)
                        .executes(上下文 => {
                            let 执行者 = 上下文.source.player;
                            if (!执行者) { 上下文.source.sendFailure(Text.of("此指令需要由玩家执行。")); return 0; }
                            let 秒数值 = 命令参数.INTEGER.getResult(上下文, "秒数");
                            设置玩家传送时限(执行者, 秒数值);
                            let 剩余秒数 = Math.floor((获取玩家传送数据(执行者).传送截止时间戳 - Date.now()) / 1000);
                            执行者.tell(Text.of(`✔ 您已获得 `).green().append(Text.of(`${剩余秒数 > 0 ? 剩余秒数 : 0} 秒`).white().bold()).append(Text.of(` 内无限传送授权。`).green()));
                            return 1;
                        })
                        .then(命令.argument("目标", P参数)
                            .executes(上下文 => {
                                let 目标p = 命令参数.PLAYER.getResult(上下文, "目标");
                                let 秒数值 = 命令参数.INTEGER.getResult(上下文, "秒数");
                                设置玩家传送时限(目标p, 秒数值);
                                let 剩余秒数 = Math.floor((获取玩家传送数据(目标p).传送截止时间戳 - Date.now()) / 1000);
                                上下文.source.sendSuccess(Text.of(`✔ 已为玩家 `).green().append(Text.of(目标p.name.string).yellow()).append(Text.of(` 设置 `).green()).append(Text.of(`${剩余秒数 > 0 ? 剩余秒数 : 0} 秒`).white().bold()).append(Text.of(` 内无限传送授权。`).green()), true);
                                if (上下文.source.player === null || !目标p.uuid.equals(上下文.source.player.uuid)) {
                                    目标p.tell(Text.of(`✔ 管理员已为您设置 `).aqua().append(Text.of(`${剩余秒数 > 0 ? 剩余秒数 : 0} 秒`).white().bold()).append(Text.of(` 内无限传送授权。`).aqua()));
                                }
                                return 1;
                            })
                        )
                    )
                )
                .then(命令.argument("目标", P参数).requires(源 => 源.hasPermission(2))
                    .executes(上下文 => {
                        let 目标p = 命令参数.PLAYER.getResult(上下文, "目标");
                        设置玩家传送次数(目标p, 1);
                        上下文.source.sendSuccess(Text.of(`✔ 已为玩家 `).green().append(Text.of(目标p.name.string).yellow()).append(Text.of(` 设置 `).green()).append(Text.of("1 次").white().bold()).append(Text.of(` 传送授权。`).green()), true);
                        if (上下文.source.player === null || !目标p.uuid.equals(上下文.source.player.uuid)) {
                             目标p.tell(Text.of(`✔ 管理员已为您设置 `).aqua().append(Text.of("1 次").white().bold()).append(Text.of(` 传送授权。`).aqua()));
                        }
                        return 1;
                    })
                )
            )
            .then(命令.literal("关闭").requires(源 => 源.hasPermission(2))
                .executes(上下文 => {
                    let 执行者 = 上下文.source.player;
                    if (!执行者) { 上下文.source.sendFailure(Text.of("此指令需要由玩家执行。")); return 0; }
                    清除玩家传送权限(执行者);
                    执行者.tell(Text.of("✖ 您的传送授权已关闭。").red());
                    return 1;
                })
                .then(命令.argument("目标", P参数).requires(源 => 源.hasPermission(2))
                    .executes(上下文 => {
                        let 目标p = 命令参数.PLAYER.getResult(上下文, "目标");
                        清除玩家传送权限(目标p);
                        上下文.source.sendSuccess(Text.of(`✖ 已关闭玩家 `).red().append(Text.of(目标p.name.string).yellow()).append(Text.of(` 的传送授权。`).red()), true);
                        if (上下文.source.player === null || !目标p.uuid.equals(上下文.source.player.uuid)) {
                            目标p.tell(Text.of(`✖ 管理员已关闭您的传送授权。`).red());
                        }
                        return 1;
                    })
                )
            )
            .then(命令.literal("帮助")
                .executes(上下文 => {
                    let 执行者 = 上下文.source.player;
                    if (!执行者) { 上下文.source.sendFailure(Text.of("帮助信息将发送给玩家,请在游戏内执行此指令查看。")); return 0; }
                    执行者.tell(Text.empty()
                        .append(Text.of(" TPD 传送授权指令帮助 ").gold().bold().underlined())
                        .append(Text.of("\n------------------------------------").darkGray())
                        .append(Text.of("\n格式: ").lightPurple().append(Text.of("/tpd <子命令> [参数...]").white()).append(Text.of(" - 命令基本结构").gray()))
                        .append(Text.of("\n\n授权管理 (需要OP权限):").aqua().bold())
                        .append(Text.of("\n  /tpd 允许").yellow()
                            .append(Text.of(" - 给予自己 ").darkAqua()).append(Text.of("1 次").white().bold()).append(Text.of(" 传送授权。").darkAqua()))
                        .append(Text.of("\n  /tpd 允许 ").yellow().append(Text.of("<目标>").lightPurple())
                            .append(Text.of(" - 给予指定玩家 ").darkGreen()).append(Text.of("1 次").white().bold()).append(Text.of(" 传送授权。").darkGreen()))
                        .append(Text.of("\n  /tpd 允许 次数 ").yellow().append(Text.of("<数量>").lightPurple()).append(Text.of(" [<目标>]").lightPurple().italic())
                            .append(Text.of(" - 设置传送授权次数 (无目标则为自己)。").darkAqua()))
                        .append(Text.of("\n  /tpd 允许 时间 ").yellow().append(Text.of("<秒数>").lightPurple()).append(Text.of(" [<目标>]").lightPurple().italic())
                            .append(Text.of(" - 设置时限内无限传送授权 (无目标则为自己)。").darkGreen()))
                        .append(Text.of("\n  /tpd 关闭 ").red().append(Text.of("[<目标>]").lightPurple().italic())
                            .append(Text.of(" - 移除传送授权 (无目标则为自己)。").gray()))
                        .append(Text.of("\n\n查询与帮助:").blue().bold())
                        .append(Text.of("\n  /tpd").yellow().append(Text.of(" (无参数) 或 ").gray()).append(Text.of("/tpd 帮助").yellow())
                            .append(Text.of(" - 显示此帮助信息并查询当前授权状态。").darkAqua()))
                        .append(Text.of("\n------------------------------------").darkGray())
                    );
                    发送传送权限信息(执行者, false);
                    return 1;
                })
            )
            .executes(上下文 => {
                return e.server.commands.performCommand(上下文.source, "tpd 帮助");
            })
    );
});

